#include "sam.h"

static int abs(int x) {           // simple function which we want to test
    if (x >= 0) {
        return x;
    }
    return -x;
}

static int testAbs() {            // simple test case
    return abs(-1) == 1 ? 1 : 0;
}


#ifdef __COVERAGESCANNER__        // Coco IO functions

// Coverage of the code below is not important for this example
#pragma CoverageScanner(cov-off)

char coverage[256];               // execution report

static int csfputs(const char *s, void *stream) {
    char **buffer_p = (char**)(stream);
    do {
        **buffer_p = *s;
        (*buffer_p)++;
        s++;
    } while (*s);
    return 1;
}

static void *csfopenappend(const char *path) {
    int i;
    static char * pp = 0 ;
    for (i = 0 ; i < sizeof( coverage )/sizeof( coverage[0] ); i++)
        coverage[i] = '\n';
    pp = coverage ;
    return (void*)( & pp );
}

static int csfclose(void *fp) {
    return 1;
}

static void saveCov() {
    __coveragescanner_set_custom_io(0, csfputs, csfopenappend,
                                    0, 0, csfclose, 0);
    __coveragescanner_save();
}

#endif

int main(void) {
    SystemInit();  // initialize the SAM system

    testAbs();     // execute test case
    
#ifdef __COVERAGESCANNER__
    saveCov();
#endif

    while (1) {}   // no exit - this is MCU
}
