import QtQuick 2.0
Item {
    id: frogButton;
    height: buttonText.height + 16
    width: buttonText.width + 24
    property alias text: buttonText.text
    signal clicked
    Rectangle {
        id: buttonRect
        anchors.fill: parent
        border.color: buttonArea.containsMouse ? "#FFFFFF" : "#49A34B"
        border.width: 2
        color: buttonArea.containsMouse ? "#5AB953" : "#49A34B"
        radius: 2
    }
    Text {
        id: buttonText
        anchors.centerIn: parent
        color: "#FFFFFF"
        text: ""
    }
    MouseArea {
        id: buttonArea
        anchors.fill: parent
        hoverEnabled: true
        onClicked: frogButton.clicked()
    }
}
